<?php
/* --------------------------------------------------------------
 Title.php 2020-08-17
 Gambio GmbH
 http://www.gambio.de

 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Modules\SetupWizard\ValueObjects;

use JsonSerializable;

/**
 * Class Title
 * @package Gambio\Admin\Modules\SetupWizard\ValueObjects
 */
class Title implements JsonSerializable
{
    /**
     * @var string
     */
    protected $title;
    
    
    /**
     * Title constructor.
     *
     * @param string $title
     */
    public function __construct(string $title)
    {
        $this->title = $title;
    }
    
    
    /**
     * @return string
     */
    public function value(): string
    {
        return $this->title;
    }
    
    
    /**
     * @inheritDoc
     */
    public function jsonSerialize()
    {
        return $this->title;
    }
}